/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.base.Predicate;
import org.python.google.common.base.Predicates;
import org.python.google.common.collect.AbstractIndexedIterator;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.ImmutableEnumSet;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.Iterables;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.UnmodifiableIterator;
import org.python.google.common.primitives.Ints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class Sets {
    private Sets() {
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(E e, E ... EArray) {
        return new ImmutableEnumSet<E[]>(EnumSet.of(e, EArray));
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return ImmutableSet.of();
        }
        if (iterable instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)iterable);
            return new ImmutableEnumSet(enumSet);
        }
        Enum enum_ = (Enum)iterator.next();
        EnumSet<Enum> enumSet = EnumSet.of(enum_);
        while (iterator.hasNext()) {
            enumSet.add((Enum)iterator.next());
        }
        return new ImmutableEnumSet<Enum>(enumSet);
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> clazz) {
        Preconditions.checkNotNull(iterable);
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        Iterables.addAll(enumSet, iterable);
        return enumSet;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... EArray) {
        int n = Maps.capacity(EArray.length);
        HashSet hashSet = new HashSet(n);
        Collections.addAll(hashSet, EArray);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int n) {
        return new HashSet(Maps.capacity(n));
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> iterable) {
        return iterable instanceof Collection ? new HashSet<E>(Collections2.cast(iterable)) : Sets.newHashSet(iterable.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> iterator) {
        HashSet<E> hashSet = Sets.newHashSet();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return new LinkedHashSet<E>(Collections2.cast(iterable));
        }
        LinkedHashSet<E> linkedHashSet = Sets.newLinkedHashSet();
        for (E e : iterable) {
            linkedHashSet.add(e);
        }
        return linkedHashSet;
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> iterable) {
        TreeSet<Comparable> treeSet = Sets.newTreeSet();
        for (Comparable comparable : iterable) {
            treeSet.add(comparable);
        }
        return treeSet;
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(Preconditions.checkNotNull(comparator));
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection) {
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection);
        }
        Preconditions.checkArgument(!collection.isEmpty(), "collection is empty; use the other version of this method");
        Class clazz = ((Enum)collection.iterator().next()).getDeclaringClass();
        return Sets.makeComplementByHand(collection, clazz);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection, Class<E> clazz) {
        Preconditions.checkNotNull(collection);
        return collection instanceof EnumSet ? EnumSet.complementOf((EnumSet)collection) : Sets.makeComplementByHand(collection, clazz);
    }

    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection, Class<E> clazz) {
        EnumSet<E> enumSet = EnumSet.allOf(clazz);
        enumSet.removeAll(collection);
        return enumSet;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    public static <E> SetView<E> union(final Set<? extends E> set, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        final SetView<? extends E> setView = Sets.difference(set2, set);
        return new SetView<E>(){

            @Override
            public int size() {
                return set.size() + setView.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty() && set2.isEmpty();
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.unmodifiableIterator(Iterators.concat(set.iterator(), setView.iterator()));
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) || set2.contains(object);
            }

            @Override
            public <S extends Set<E>> S copyInto(S s) {
                s.addAll(set);
                s.addAll(set2);
                return s;
            }

            @Override
            public ImmutableSet<E> immutableCopy() {
                return ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)set)).addAll((Iterable)set2)).build();
            }
        };
    }

    public static <E> SetView<E> intersection(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        final Predicate<?> predicate = Predicates.in(set2);
        return new SetView<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(set.iterator(), predicate);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && set2.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection) && set2.containsAll(collection);
            }
        };
    }

    public static <E> SetView<E> difference(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        final Predicate<?> predicate = Predicates.not(Predicates.in(set2));
        return new SetView<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(set.iterator(), predicate);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && !set2.contains(object);
            }
        };
    }

    @Beta
    public static <E> SetView<E> symmetricDifference(Set<? extends E> set, Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return Sets.difference(Sets.union(set, set2), Sets.intersection(set, set2));
    }

    public static <E> Set<E> filter(Set<E> set, Predicate<? super E> predicate) {
        if (set instanceof FilteredSet) {
            FilteredSet filteredSet = (FilteredSet)set;
            Predicate<? super E> predicate2 = Predicates.and(filteredSet.predicate, predicate);
            return new FilteredSet<E>((Set)filteredSet.unfiltered, predicate2);
        }
        return new FilteredSet<E>(Preconditions.checkNotNull(set), Preconditions.checkNotNull(predicate));
    }

    public static <B> Set<List<B>> cartesianProduct(List<? extends Set<? extends B>> list) {
        CartesianSet cartesianSet = new CartesianSet(list);
        return cartesianSet.isEmpty() ? ImmutableSet.of() : cartesianSet;
    }

    public static <B> Set<List<B>> cartesianProduct(Set<? extends B> ... setArray) {
        return Sets.cartesianProduct(Arrays.asList(setArray));
    }

    @GwtCompatible(serializable=false)
    public static <E> Set<Set<E>> powerSet(Set<E> set) {
        ImmutableSet<E> immutableSet = ImmutableSet.copyOf(set);
        Preconditions.checkArgument(immutableSet.size() <= 30, "Too many elements to create power set: %s > 30", immutableSet.size());
        return new PowerSet<E>(immutableSet);
    }

    static int hashCodeImpl(Set<?> set) {
        int n = 0;
        for (Object obj : set) {
            n += obj != null ? obj.hashCode() : 0;
        }
        return n;
    }

    static boolean equalsImpl(Set<?> set, @Nullable Object object) {
        if (set == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set2 = (Set)object;
            try {
                return set.size() == set2.size() && set.containsAll(set2);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CartesianSet<B>
    extends AbstractSet<List<B>> {
        final ImmutableList<Axis> axes;
        final int size;

        CartesianSet(List<? extends Set<? extends B>> list) {
            long l = 1L;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Set<B> set : list) {
                Axis axis = new Axis(set, (int)l);
                builder.add(axis);
                l *= (long)axis.size();
            }
            this.axes = builder.build();
            this.size = Ints.checkedCast(l);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public UnmodifiableIterator<List<B>> iterator() {
            return new UnmodifiableIterator<List<B>>(){
                int index;

                @Override
                public boolean hasNext() {
                    return this.index < CartesianSet.this.size;
                }

                @Override
                public List<B> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object[] objectArray = new Object[CartesianSet.this.axes.size()];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = ((Axis)CartesianSet.this.axes.get(i)).getForIndex(this.index);
                    }
                    ++this.index;
                    ImmutableList<Object> immutableList = ImmutableList.copyOf(objectArray);
                    return immutableList;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            int n = this.axes.size();
            if (list.size() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (((Axis)this.axes.get(i)).contains(list.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof CartesianSet) {
                CartesianSet cartesianSet = (CartesianSet)object;
                return this.axes.equals(cartesianSet.axes);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n = this.size - 1;
            for (int i = 0; i < this.axes.size(); ++i) {
                n *= 31;
            }
            return this.axes.hashCode() + n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Axis {
            final ImmutableSet<? extends B> choices;
            final ImmutableList<? extends B> choicesList;
            final int dividend;

            Axis(Set<? extends B> set, int n) {
                this.choices = ImmutableSet.copyOf(set);
                this.choicesList = this.choices.asList();
                this.dividend = n;
            }

            int size() {
                return this.choices.size();
            }

            B getForIndex(int n) {
                return this.choicesList.get(n / this.dividend % this.size());
            }

            boolean contains(Object object) {
                return this.choices.contains(object);
            }

            public boolean equals(Object object) {
                if (object instanceof Axis) {
                    Axis axis = (Axis)object;
                    return this.choices.equals(axis.choices);
                }
                return false;
            }

            public int hashCode() {
                return CartesianSet.this.size / this.choices.size() * this.choices.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredSet<E>
    extends Collections2.FilteredCollection<E>
    implements Set<E> {
        FilteredSet(Set<E> set, Predicate<? super E> predicate) {
            super(set, predicate);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return Sets.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PowerSet<E>
    extends AbstractSet<Set<E>> {
        final ImmutableSet<E> inputSet;
        final ImmutableList<E> inputList;
        final int powerSetSize;

        PowerSet(ImmutableSet<E> immutableSet) {
            this.inputSet = immutableSet;
            this.inputList = immutableSet.asList();
            this.powerSetSize = 1 << immutableSet.size();
        }

        @Override
        public int size() {
            return this.powerSetSize;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new AbstractIndexedIterator<Set<E>>(this.powerSetSize){

                @Override
                protected Set<E> get(final int n) {
                    return new AbstractSet<E>(){

                        @Override
                        public int size() {
                            return Integer.bitCount(n);
                        }

                        @Override
                        public Iterator<E> iterator() {
                            return new BitFilteredSetIterator(PowerSet.this.inputList, n);
                        }
                    };
                }
            };
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Set) {
                Set set = (Set)object;
                return this.inputSet.containsAll(set);
            }
            return false;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof PowerSet) {
                PowerSet powerSet = (PowerSet)object;
                return this.inputSet.equals(powerSet.inputSet);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return this.inputSet.hashCode() << this.inputSet.size() - 1;
        }

        @Override
        public String toString() {
            return "powerSet(" + this.inputSet + ")";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class BitFilteredSetIterator<E>
        extends UnmodifiableIterator<E> {
            final ImmutableList<E> input;
            int remainingSetBits;

            BitFilteredSetIterator(ImmutableList<E> immutableList, int n) {
                this.input = immutableList;
                this.remainingSetBits = n;
            }

            @Override
            public boolean hasNext() {
                return this.remainingSetBits != 0;
            }

            @Override
            public E next() {
                int n = Integer.numberOfTrailingZeros(this.remainingSetBits);
                if (n == 32) {
                    throw new NoSuchElementException();
                }
                int n2 = 1 << n;
                this.remainingSetBits &= ~n2;
                return this.input.get(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        @GwtIncompatible(value="not needed in emulated source")
        private static final long serialVersionUID = 0L;

        SetFromMap(Map<E, Boolean> map) {
            Preconditions.checkArgument(map.isEmpty(), "Map is non-empty");
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.s.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return ((Object)this.s).hashCode();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return this == object || ((Object)this.s).equals(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.s.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.s.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.s.retainAll(collection);
        }

        @GwtIncompatible(value="java.io.ObjectInputStream")
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.s = this.m.keySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        public ImmutableSet<E> immutableCopy() {
            return ImmutableSet.copyOf(this);
        }

        public <S extends Set<E>> S copyInto(S s) {
            s.addAll(this);
            return s;
        }
    }
}

